#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Hall9000Mod01.fsh    by    diatribes  
//https://www.shadertoy.com/view/M3cBzS
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Raymarch article with repeating example:
// https://blog.maximeheckel.com/posts/painting-with-math-a-gentle-study-of-raymarching/

#define FRACT_MIN .3
#define FRACT_MAX .8
#define FRACT_OFFSET 1.75

#define MAX_STEPS 8
#define MAX_DIST 14.0
#define SURFACE_DIST .001
#define inf (MAX_DIST+1.0)

vec3 repeat(vec3 p, float c) {
  return mod(p,c)-0.5*c;
}

float sdBox(vec3 p, vec3 b) {
  vec3 q = abs(p) - b;
  return length(max(q, 0.0)) + min(max(q.x, max(q.y, q.z)), 0.0);
}

float sdCross(in vec3 p, float s) {
  float da = sdBox(p.xyz, vec3(s, s, s));
  float db = sdBox(p.yzx, vec3(s, inf, s));
  float dc = sdBox(p.zxy, vec3(s, s, inf));
  return min(da, min(db, dc));
}

// modified from the fractal function found here:
// https://www.shadertoy.com/view/4XdfW4
// is there a name for this type of fractal?
float fractal(vec3 p, out vec3 rgb, int iterations){
  float m = 1.;
  for (int i = 0; i < iterations; i++) {
        float n = abs(p.x*p.y*p.z);
        p = abs(p)/clamp(n,FRACT_MIN,FRACT_MAX)-FRACT_OFFSET;
        m = abs(min(p.x,min(p.y,p.z)));
  }
  m = exp(-2. * m)*3.;
  rgb=vec3(2.0, p.xy) * m;
  return length(rgb);
}

float scene(vec3 p) {
  vec3 s = repeat(p, 2.0);
  float cross = sdCross(s, .125);
  return min(1.0-p.x,min(1.0+p.x,min(1.0+p.y,min(1.0-p.y,cross))));
}

float raymarch(vec3 ro, vec3 rd) {
  float dist = 0.0;
  for(int i = 0; i < MAX_STEPS; i++) {

    // Ray origin extended by dist in rd direction
    vec3 p = ro + rd * dist;

    // Calculate the distance from the current position
    // to an object in the scene or infinity
    float step = scene(p);

    // Track the total distance of the ray
    dist += step;

    // If we've gone too far, or are very close to a surface
    if(dist > MAX_DIST || step < SURFACE_DIST) {
        break;
    }
  }

  // Infinity or the distance to a surface
  return dist;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
  vec2 uv = fragCoord.xy/iResolution.xy-.5;
  uv.x *= iResolution.x / iResolution.y;

  vec3 ro = vec3(0.0, sin(iTime*.25)*.5, -iTime*.8);
  vec3 rd = normalize(vec3(uv, -1.0));
  float sa = sin(sin(iTime*.15));
  float ca = cos(cos(iTime*.15));
  mat2 m = mat2(ca, sa, -sa, ca);
  rd.xy *= m;
  
  float d = raymarch(ro, rd);
  vec3 color = vec3(0.0);
  vec3 p = ro + rd * d;
  vec3 s = repeat(p, 2.0);
  
  d += fractal(s, color,5);
  vec3 color2;
  fractal(s,color2,1);
  color *= (2.0/d);
  color = mix(color, color2, vec3(.5));

  fragColor = vec4(color, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

